/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.data;

import frc.emul.config.data.CfgItemBankMenu;
import frc.emul.config.data.CfgItemCartridge;
import frc.emul.config.data.CfgItemCartridgePart;
import frc.util.IStream;
import frc.util.IStreamFactory;
import java.util.ArrayList;
import java.util.List;

public class CfgItemCartridgeComposite
extends CfgItemCartridge {
    public final List<CfgItemCartridgePart> banks = new ArrayList<CfgItemCartridgePart>();
    public boolean dualMode;
    public CfgItemBankMenu menu;

    public CfgItemCartridgeComposite(String string, String string2) {
        super(string, string2);
    }

    public boolean isZippedEntry() {
        for (CfgItemCartridgePart cfgItemCartridgePart : this.banks) {
            if (!cfgItemCartridgePart.isCartZipEntry()) continue;
            return true;
        }
        return false;
    }

    public boolean isComposite() {
        return true;
    }

    public boolean hasCartridge() {
        return !this.banks.isEmpty();
    }

    protected IStream createCartridgeStream() {
        ArrayList<IStream> arrayList = new ArrayList<IStream>();
        if (this.hasMenu() && this.menu.hasContent()) {
            IStream object = this.menu.generateContent(this.banks);
            arrayList.add(object);
        }
        for (CfgItemCartridgePart cfgItemCartridgePart : this.banks) {
            arrayList.add(cfgItemCartridgePart.getCartridgeStream());
        }
        return IStreamFactory.mergeBanks(this.name, arrayList, (byte)-1);
    }

    public String getCartridgePath() {
        return this.hasCartridge() ? this.banks.get((int)0).cartridgePath : null;
    }

    public String getCartridgeZipPath() {
        return this.hasCartridge() ? this.banks.get((int)0).cartZipEntry : null;
    }

    public boolean hasMenu() {
        return this.menu != null;
    }

    public int getTotalBanksCount() {
        return (this.hasMenu() ? 1 : 0) + this.banks.size();
    }
}

